//+------------------------------------------------------------------+
//|   TRO_forexgreenland                                             |
//|                                                                  | 
//|   Copyright  2008, Avery T. Horton, Jr. aka TheRumpledOne       |
//|                                                                  |
//|   PO BOX 43575, TUCSON, AZ 85733                                 |
//|                                                                  |
//|   GIFTS AND DONATIONS ACCEPTED                                   | 
//|                                                                  |
//|   therumpledone@gmail.com                                        |  
//+------------------------------------------------------------------+ 

#property  copyright "Copyright  2008, Avery T. Horton, Jr. aka TRO" 
#property  link      "http://www.therumpledone.com/" 

#property indicator_chart_window
 


//---- input parameters 

extern bool Show.Labels = true ;
extern bool Show.Gauge  = true ;

extern double    myUpper      = 0 ; 
extern double    myLower      = 0 ;
extern double    myWindow     = 0.60 ;
extern int       myBars       = 34 ;
extern int       myShift      = 1 ;

extern int myChartY = 1 ;
extern bool Horizontal = true ;

extern color ColorHeading = DimGray;
extern color ColorUpper = Red ;
extern color ColorShort = Crimson ;
extern color ColorLong  = Green ;
extern color ColorLower = Blue ;

//---- buffers


int i;
  
double R1, R2, R3 ;  

double X05 ;
double X06 ;   
double X07 ;
double X08, XRN ; 
double xRet ;
double xRetPct;    
  
string tChartPeriod ; 

string tLabel01, tLabel02, tLabel03, tLabel04, tLabel05, tLabel06, tLabel07 ;   
string tRes0 = "pRes_0" ;
string tSup0 = "pSup_0" ;
string tFib1 = "pFib1_0" ;
string tFib2 = "pFib2_0" ;

double range  ;
double DynR; 
double DynS;  
datetime StartTime;
int digits ;

double Entry, work, goShort, goLong, reward, risk, ratio ;

bool xAutoCalc = false;
int nHH, nLL; 
string tPIVOT0 ="fgres" ;
string tPIVOT1 ="fgsup" ; 
string tPIVOT2 ="fgslo" ;
//+------------------------------------------------------------------+
   
int init()
  {


  tChartPeriod =  TimeFrameToString(Period()) ;

  tLabel01 = "1Resistance" + tChartPeriod ;
  tLabel02 = "2Support" + tChartPeriod ;
  tLabel03 = "3Short" + tChartPeriod ; 
  tLabel04 = "4Long" + tChartPeriod ;

  
  digits = Digits ;
      
  
  if( myUpper == 0 ) { xAutoCalc = true ; }   
      
 work    = ( myUpper  - myLower ) * myWindow  ; 
   
 goShort = myLower  + work   ;
 goLong  = myUpper  - work   ;
 

 reward   = myUpper - goLong ;
 risk     = goLong - myLower ;
 ratio    = reward / risk ;
 

   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectsDeleteAll( 0, OBJ_FIBO ) ;
   ObjectDelete(tPIVOT0);
   ObjectDelete(tPIVOT1); 
   ObjectDelete(tPIVOT2);      
   ObjectDelete("SRFP");
   ObjectDelete("line5SRFP");
   ObjectDelete("R3_lSRFP");
   ObjectDelete("R3_vSRFP");  
   ObjectDelete("R2_lSRFP"); 
   ObjectDelete("R2_vSRFP");
   ObjectDelete("R1_lSRFP");
   ObjectDelete("R1_vSRFP");
   ObjectDelete("Pivot_lSRFP");
   ObjectDelete("Pivot_vSRFP");
   ObjectDelete( "X08_ValueSRF" );
   ObjectDelete(  "X08_LabelSRF" );   
   ObjectDelete(  "X07_ValueSRF" );
   ObjectDelete(  "X07_LabelSRF" );
   ObjectDelete(  "X06_ValueSRF" );
   ObjectDelete(  "X06_LabelSRF" );
   ObjectDelete(  "X05_ValueSRF" );
   ObjectDelete( "X05_LabelSRF" );
   ObjectDelete("Res_SRP");      
   ObjectDelete("Sup_SRP");           
   ObjectDelete("+618_SRP"); 
   ObjectDelete("+382_SRP");      
   ObjectDelete("-618_SRP"); 
   ObjectDelete("-382_SRP");  
   ObjectDelete( "XRN_ValueSRF" );
   ObjectDelete(  "XRN_LabelSRF" );  
   

       
   return(0);
  }

int start()
{

if( xAutoCalc == true ) DoWork() ;  

if( Show.Labels) DoShowLabels() ;

if( Show.Gauge ) DoShowGauge() ;

 
 
   return(0); 
} 
//+------------------------------------------------------------------+ 

void DoWork()
{
  
/*   
Reward = Target Point - Entry Point = 1.9869-1.9782 = 87 pips

Risk= Entry Point - Stop Loss = 1.9782 - 1.9747 = 35pips

Risk to Reward Ratio = 87 / 35 = 1:2.5

*/
 
 nHH      =  Highest(NULL,0,MODE_HIGH,myBars,myShift); 
 nLL      =  Lowest(NULL,0,MODE_LOW,myBars,myShift); 
 
 myUpper      = High[nHH]; 
 myLower      = Low[nLL]; 

      
 work     = ( myUpper  - myLower ) * myWindow  ; 
   
 goShort  = myLower  + work   ;
 goLong   = myUpper  - work   ;
 
 reward   = myUpper - goLong ;
 risk     = goLong - myLower ;
 ratio    = reward / risk ;
 

} 
//+------------------------------------------------------------------+ 

 
void DoShowGauge()
{

string StrX05 = "+Fib618" ; 
string StrX06 = "+Fib382" ; 
string StrX07 = "-Fib382" ; 
string StrX08 = "-Fib618" ;  
string StrXRN = "Range" ;  
  
        
	
	int Precision, dig;	

   dig = Digits ;

 
int sPeriod= Period();
     	
//---- Set Pivots labels

   int WindowToUse;
   int Corner_line, Xdist_line;
   int Corner_text, Corner_vSRFP, Xdist_text, Xdist_vSRFP;
   int Ydist_line5;
   int Corner_pivots, Xdist_pivots, Ydist_pivots;
   int Ydist_R3, Ydist_R2, Ydist_R1, Ydist_PV, Ydist_S1, Ydist_S2, Ydist_S3, Ydist_X05, Ydist_X06, Ydist_X07, Ydist_X08, Ydist_XRN ;
  
   int YdistInc ;
    WindowToUse =  0;
    Corner_line = 1;
    Corner_text = 1; Corner_vSRFP = 1;
    Xdist_line = 21; Xdist_text = 93; Xdist_vSRFP = 23;
    Corner_pivots = 1; Xdist_pivots = 21; 
    Ydist_pivots = myChartY;  
    Ydist_line5 = Ydist_pivots + 11; YdistInc = 15 ;
    Ydist_R3 = Ydist_pivots + 25; 
    Ydist_R2 = Ydist_R3 + YdistInc; 
    Ydist_R1 = Ydist_R3 + YdistInc*2; 
    Ydist_PV = Ydist_R3 + YdistInc*3; 
    Ydist_X05 = Ydist_R3 + YdistInc*4;
    Ydist_X06 = Ydist_R3 + YdistInc*5;    
    Ydist_X07 = Ydist_R3 + YdistInc*6;
    Ydist_X08 = Ydist_R3 + YdistInc*7;    
    Ydist_XRN = Ydist_R3 + YdistInc*8;    

 


  if (ObjectFind(tPIVOT0) != 0)
      {
          ObjectCreate(tPIVOT0,OBJ_ARROW,0,Time[nHH],myLower);
          ObjectSet(tPIVOT0,OBJPROP_ARROWCODE,217);
//          ObjectSet(tPIVOT0,OBJPROP_WIDTH,myBoxWidth);  
          ObjectSet(tPIVOT0,OBJPROP_COLOR,ColorUpper);  
      } 
      else
      {
         ObjectMove(tPIVOT0,0,Time[nHH],myLower);
      }


 
  if (ObjectFind(tPIVOT1) != 0)
      {
          ObjectCreate(tPIVOT1,OBJ_ARROW,0,Time[myBars],myLower);
          ObjectSet(tPIVOT1,OBJPROP_ARROWCODE,217);
//          ObjectSet(tPIVOT1,OBJPROP_WIDTH,myBoxWidth);  
          ObjectSet(tPIVOT1,OBJPROP_COLOR,ColorHeading);  
      } 
      else
      {
         ObjectMove(tPIVOT1,0,Time[myBars],myLower);
      }

  if (ObjectFind(tPIVOT2) != 0)
      {
          ObjectCreate(tPIVOT2,OBJ_ARROW,0,Time[nLL],myLower);
          ObjectSet(tPIVOT2,OBJPROP_ARROWCODE,217);
//          ObjectSet(tPIVOT2,OBJPROP_WIDTH,myBoxWidth);  
          ObjectSet(tPIVOT2,OBJPROP_COLOR,ColorLower);  
      } 
      else
      {
         ObjectMove(tPIVOT2,0,Time[nLL],myLower);
      }
      
   ObjectCreate("SRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("SRFP", "AXN("+myBars+")."+myShift,9, "Verdana", ColorHeading);
   ObjectSet("SRFP", OBJPROP_CORNER, Corner_pivots);
   ObjectSet("SRFP", OBJPROP_XDISTANCE, Xdist_pivots);
   ObjectSet("SRFP", OBJPROP_YDISTANCE, Ydist_pivots);
   
   ObjectCreate("line5SRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("line5SRFP","-----------------------------",7, "Verdana", ColorHeading);
   ObjectSet("line5SRFP", OBJPROP_CORNER, Corner_line);
   ObjectSet("line5SRFP", OBJPROP_XDISTANCE, Xdist_line);
   ObjectSet("line5SRFP", OBJPROP_YDISTANCE, Ydist_line5);
   
   ObjectCreate("R3_lSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R3_lSRFP","Resistance",9, "Verdana", ColorUpper);
   ObjectSet("R3_lSRFP", OBJPROP_CORNER, Corner_text);
   ObjectSet("R3_lSRFP", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("R3_lSRFP", OBJPROP_YDISTANCE, Ydist_R3);

   ObjectCreate("R3_vSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R3_vSRFP"," "+DoubleToStr(myUpper,dig),9, "Verdana", ColorUpper);
   ObjectSet("R3_vSRFP", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("R3_vSRFP", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("R3_vSRFP", OBJPROP_YDISTANCE, Ydist_R3);
   
   ObjectCreate("R2_lSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R2_lSRFP","Go Short",9, "Verdana", ColorShort);
   ObjectSet("R2_lSRFP", OBJPROP_CORNER, Corner_text);
   ObjectSet("R2_lSRFP", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("R2_lSRFP", OBJPROP_YDISTANCE, Ydist_R2);
   
   ObjectCreate("R2_vSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R2_vSRFP"," "+DoubleToStr(goShort,dig),9, "Verdana", ColorShort);
   ObjectSet("R2_vSRFP", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("R2_vSRFP", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("R2_vSRFP", OBJPROP_YDISTANCE, Ydist_R2);
   

   ObjectCreate("R1_lSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R1_lSRFP","Go Long",9, "Verdana", ColorLong );
   ObjectSet("R1_lSRFP", OBJPROP_CORNER, Corner_text);
   ObjectSet("R1_lSRFP", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("R1_lSRFP", OBJPROP_YDISTANCE, Ydist_R1);
   
   ObjectCreate("R1_vSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("R1_vSRFP"," "+DoubleToStr(goLong,dig),9, "Verdana", ColorLong);
   ObjectSet("R1_vSRFP", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("R1_vSRFP", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("R1_vSRFP", OBJPROP_YDISTANCE, Ydist_R1);
   
   ObjectCreate("Pivot_lSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("Pivot_lSRFP","Support",9, "Verdana", ColorLower);
   ObjectSet("Pivot_lSRFP", OBJPROP_CORNER, Corner_text);
   ObjectSet("Pivot_lSRFP", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("Pivot_lSRFP", OBJPROP_YDISTANCE, Ydist_PV);
   
   ObjectCreate("Pivot_vSRFP", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("Pivot_vSRFP"," "+DoubleToStr(myLower,dig),9, "Verdana", ColorLower);
   ObjectSet("Pivot_vSRFP", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("Pivot_vSRFP", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("Pivot_vSRFP", OBJPROP_YDISTANCE, Ydist_PV);   
 

   ObjectCreate("X05_LabelSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X05_LabelSRF","RISK ",9, "Verdana", ColorHeading );
   ObjectSet("X05_LabelSRF", OBJPROP_CORNER, Corner_text);
   ObjectSet("X05_LabelSRF", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("X05_LabelSRF", OBJPROP_YDISTANCE, Ydist_X05);
   
   ObjectCreate("X05_ValueSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X05_ValueSRF"," "+DoubleToStr(risk/Point,0),9, "Verdana", ColorHeading);
   ObjectSet("X05_ValueSRF", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("X05_ValueSRF", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("X05_ValueSRF", OBJPROP_YDISTANCE, Ydist_X05);
    
   ObjectCreate("X06_LabelSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X06_LabelSRF","REWARD",9, "Verdana", ColorHeading );
   ObjectSet("X06_LabelSRF", OBJPROP_CORNER, Corner_text);
   ObjectSet("X06_LabelSRF", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("X06_LabelSRF", OBJPROP_YDISTANCE, Ydist_X06);
   
   ObjectCreate("X06_ValueSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X06_ValueSRF"," "+DoubleToStr(reward/Point,0),9, "Verdana", ColorHeading);
   ObjectSet("X06_ValueSRF", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("X06_ValueSRF", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("X06_ValueSRF", OBJPROP_YDISTANCE, Ydist_X06);

   ObjectCreate("X07_LabelSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X07_LabelSRF","RATIO",9, "Verdana", ColorHeading );
   ObjectSet("X07_LabelSRF", OBJPROP_CORNER, Corner_text);
   ObjectSet("X07_LabelSRF", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("X07_LabelSRF", OBJPROP_YDISTANCE, Ydist_X07);
   
   ObjectCreate("X07_ValueSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X07_ValueSRF"," "+DoubleToStr(ratio,dig),9, "Verdana", ColorHeading);
   ObjectSet("X07_ValueSRF", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("X07_ValueSRF", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("X07_ValueSRF", OBJPROP_YDISTANCE, Ydist_X07);

   ObjectCreate("X08_LabelSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X08_LabelSRF","WINDOW",9, "Verdana", ColorHeading );
   ObjectSet("X08_LabelSRF", OBJPROP_CORNER, Corner_text);
   ObjectSet("X08_LabelSRF", OBJPROP_XDISTANCE, Xdist_text);
   ObjectSet("X08_LabelSRF", OBJPROP_YDISTANCE, Ydist_X08);
   
   ObjectCreate("X08_ValueSRF", OBJ_LABEL, WindowToUse, 0, 0);
   ObjectSetText("X08_ValueSRF"," "+DoubleToStr(myWindow,2),9, "Verdana", ColorHeading);
   ObjectSet("X08_ValueSRF", OBJPROP_CORNER, Corner_vSRFP);
   ObjectSet("X08_ValueSRF", OBJPROP_XDISTANCE, Xdist_vSRFP);
   ObjectSet("X08_ValueSRF", OBJPROP_YDISTANCE, Ydist_X08);

} 

void DoShowLabels()
{
   range = myUpper  - myLower  ;
	if(ObjectFind(tRes0) == -1)
		ObjectCreate(tRes0,OBJ_FIBO,0,StartTime,myUpper+range,StartTime,myUpper);
	else
	{
		ObjectSet(tRes0,OBJPROP_TIME2, StartTime);
		ObjectSet(tRes0,OBJPROP_TIME1, StartTime);
		ObjectSet(tRes0,OBJPROP_PRICE1,myUpper+range);
		ObjectSet(tRes0,OBJPROP_PRICE2,myUpper);
	}
   ObjectSet(tRes0,OBJPROP_LEVELCOLOR,ColorUpper);
   ObjectSet(tRes0,OBJPROP_FIBOLEVELS,1);
   ObjectSet(tRes0,OBJPROP_FIRSTLEVEL+0,0.0);	
   ObjectSetFiboDescription(tRes0,0, DoubleToStr(myUpper,digits)+ " RES  "); 
   ObjectSet(tRes0,OBJPROP_RAY,true);
   ObjectSet(tRes0,OBJPROP_BACK,true);


		if(ObjectFind(tSup0) == -1)
			ObjectCreate(tSup0,OBJ_FIBO,0,StartTime,myLower-range,StartTime+PERIOD_H4*60,myLower);
		else
		{
			ObjectSet(tSup0,OBJPROP_TIME2, StartTime);
			ObjectSet(tSup0,OBJPROP_TIME1, StartTime);
			ObjectSet(tSup0,OBJPROP_PRICE1,myUpper);
			ObjectSet(tSup0,OBJPROP_PRICE2,myLower);
		}
   	ObjectSet(tSup0,OBJPROP_LEVELCOLOR,ColorLower); 
   	ObjectSet(tSup0,OBJPROP_FIBOLEVELS,1);
   
   	ObjectSet(tSup0,OBJPROP_FIRSTLEVEL+0,0.000);	
   	ObjectSetFiboDescription(tSup0,0,DoubleToStr(myLower,digits)+ " SUP  "); 

   	ObjectSet(tSup0,OBJPROP_RAY,true);
   	ObjectSet(tSup0,OBJPROP_BACK,true);

   
		if(ObjectFind(tFib1) == -1)
			ObjectCreate(tFib1,OBJ_FIBO,0,StartTime,myUpper,StartTime+PERIOD_H4*60,myLower);
		else
		{
			ObjectSet(tFib1,OBJPROP_TIME2, StartTime);
			ObjectSet(tFib1,OBJPROP_TIME1, StartTime);
			ObjectSet(tFib1,OBJPROP_PRICE1,myUpper);
			ObjectSet(tFib1,OBJPROP_PRICE2,myLower);
		}
   	ObjectSet(tFib1,OBJPROP_LEVELCOLOR,ColorShort); 
   	ObjectSet(tFib1,OBJPROP_FIBOLEVELS,1);
   
   	ObjectSet(tFib1,OBJPROP_FIRSTLEVEL+0,myWindow);	
   	ObjectSetFiboDescription(tFib1,0,DoubleToStr(goShort,digits)+ " S E L L  "); 

   	ObjectSet(tFib1,OBJPROP_RAY,true);
   	ObjectSet(tFib1,OBJPROP_BACK,true);
  
   
		if(ObjectFind(tFib2) == -1)
			ObjectCreate(tFib2,OBJ_FIBO,0,StartTime,myUpper,StartTime+PERIOD_H4*60,myLower);
		else
		{
			ObjectSet(tFib2,OBJPROP_TIME2, StartTime);
			ObjectSet(tFib2,OBJPROP_TIME1, StartTime);
			ObjectSet(tFib2,OBJPROP_PRICE1,myUpper);
			ObjectSet(tFib2,OBJPROP_PRICE2,myLower);
		}
   	ObjectSet(tFib2,OBJPROP_LEVELCOLOR,ColorLong); 
   	ObjectSet(tFib2,OBJPROP_FIBOLEVELS,2);
   
   	ObjectSet(tFib2,OBJPROP_FIRSTLEVEL+0,1-myWindow);	
   	ObjectSetFiboDescription(tFib2,0,DoubleToStr(goLong,digits)+ " - BUY -  "); 

   	ObjectSet(tFib2,OBJPROP_RAY,true);
   	ObjectSet(tFib2,OBJPROP_BACK,true);

      
}

//+------------------------------------------------------------------+ 

string TimeFrameToString(int tf)
{
   string tfs;
   switch(tf) {
      case PERIOD_M1:  tfs="M1"  ; break;
      case PERIOD_M5:  tfs="M5"  ; break;
      case PERIOD_M15: tfs="M15" ; break;
      case PERIOD_M30: tfs="M30" ; break;
      case PERIOD_H1:  tfs="H1"  ; break;
      case PERIOD_H4:  tfs="H4"  ; break;
      case PERIOD_D1:  tfs="D1"  ; break;
      case PERIOD_W1:  tfs="W1"  ; break;
      case PERIOD_MN1: tfs="MN";
   }
   return(tfs);
}

//+------------------------------------------------------------------+ 

/*
Comment(
"myUpper = ", DoubleToStr( myUpper, Digits), "\n",
"myLower = ", DoubleToStr( myLower, Digits), "\n",
"reward = ", DoubleToStr( reward, Digits), "\n",
"risk = ", DoubleToStr( risk, Digits), "\n",
"ratio = ", DoubleToStr( ratio, Digits), "\n",

"") ;

*/